'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Befehl_Textdatei_lesen_Click()
    Dim DateiSuche As String
    
    
    'Sicherheitsfrage
    If MsgBox("Sollen die Kategorien der Textdatei in die Vorgabenliste bernommen werden?", vbYesNo + vbQuestion + vbDefaultButton2, "Kategorievorgaben") <> vbYes Then
        Exit Sub
    End If
    
    
    'Prfung, ob angegebene Datei vorhanden ist
    DateiSuche = ""
    On Error Resume Next                    'Meldung "Pfad nicht gefunden" unterdrcken!
    DateiSuche = Dir(Trim(Me.Pfadeingabe.Value))
    'On Error GoTo Err_....     'Fehlerbehandlung wieder einschalten
    If (DateiSuche = "") Then               'Datei auch vorhanden?
        MsgBox "Die angegebene Textdatei wurde nicht gefunden.", vbOKOnly + vbCritical, "Fehler"
        Me.Pfadeingabe.SetFocus
        Exit Sub
    End If
    KatListeDatei = Trim(Me.Pfadeingabe.Value)
    
    
    'brige Parameter der Maske prfen
    KatWoVon = Me.Feld_WoVon.Value
    KatWoBis = Me.Feld_WoBis.Value
    KatOrt = Me.Feld_KategorieWo.Value                      ' D-atenfeld oder absolute P-osition
    KatTrennzeichen = Me.Feld_Trennzeichen.Value
    KatAnfuehrung = Me.Feld_Anfuehrung.Value
    
    If (KatWoVon < 0) Or (KatWoVon > 250) Then
        MsgBox "Die Zahl fr den Beginn muss zwischen 0 und 250 liegen.", vbOKOnly + vbCritical, "Fehler"
        Me.Feld_WoVon.SetFocus
        Exit Sub
    End If

    If KatOrt = "P" Then
        'KatOrt ist "P"-osition
        If (KatWoBis < 0) Or (KatWoBis > 250) Then
            MsgBox "Die Zahl fr das Ende muss zwischen 0 und 250 liegen.", vbOKOnly + vbCritical, "Fehler"
            Me.Feld_WoBis.SetFocus
            Exit Sub
        End If
        If KatWoBis < KatWoVon Then
            MsgBox "Die Zahl fr das Ende muss grer oder gleich der Zahl fr den Beginn sein.", vbOKOnly + vbCritical, "Fehler"
            Me.Feld_WoBis.SetFocus
            Exit Sub
        End If
    End If
    
    
    'Hinweis zum Warten anzeigen
    DoCmd.OpenForm "Bitte_warten"
    Forms![Bitte_warten].Repaint
    
    'Start der Routine zur Aktualisierung der internen Kategorievorgabeliste durch externe Datei
    Call KategorieVorgabeliste_Aktualisieren
    
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
    
    'Anzeige aktualisieren
    ''Forms![Einstellungen_6].[Kategorievorgaben].Form.Requery
    Me.Kategorievorgaben.Form.Requery
    
End Sub

Private Sub Befehl13_Click()
On Error GoTo Err_Befehl13_Click

    Dim Pfad, AktVerzeichnis As String
    
    AktVerzeichnis = Left(CurrentDb.Name, Len(CurrentDb.Name) - Len(Dir(CurrentDb.Name)))
    Pfad = DateiOeffnen(AktVerzeichnis, "Datei mit Kategorienliste ffnen")
    
    If Len(Pfad) > 1 Then
        Me.Pfadeingabe.Value = Pfad
    End If
    
    Me.Pfadeingabe.SetFocus
    Me.Pfadeingabe.SelStart = 500       'Cursor ans Ende setzen
    
    
Exit_Befehl13_Click:
    Exit Sub

Err_Befehl13_Click:
    MsgBox err.Description
    Resume Exit_Befehl13_Click
    

End Sub

Private Sub Befehl93_Click()
    DoCmd.Close
End Sub

Private Sub Feld_KategorieWo_Change()
    'Aktivierung/Deaktivierung briger Felder
    If Me.Feld_UebernahmeArt.Value = 1 Then         ' nur ausfhren, wenn Kategorieliste aktiviert ist
        If Me.Feld_KategorieWo.Value = "P" Then     ' "P" absolute Position oder "D" Datensatz
            Me.Feld_WoBis.Enabled = True
            Me.Feld_Trennzeichen.Enabled = False
        Else
            Me.Feld_WoBis.Enabled = False
            Me.Feld_Trennzeichen.Enabled = True
        End If
    End If
End Sub

Private Sub Feld_UebernahmeArt_AfterUpdate()
    'Felder aktivieren/deaktivieren
    If Me.Feld_UebernahmeArt.Value = 0 Then
        '...alle Kategorien
        Me.Kategorievorgaben.Enabled = False
        Me.Befehl_Textdatei_lesen.Enabled = False
        Me.Pfadeingabe.Enabled = False
        Me.Feld_KategorieWo.Enabled = False
        Me.Feld_WoVon.Enabled = False
        Me.Feld_WoBis.Enabled = False
        Me.Feld_Trennzeichen.Enabled = False
        Me.Feld_Anfuehrung.Enabled = False
        Me.Befehl13.Enabled = False                 'Datei suchen
        Me.Kontrollkstchen187.Enabled = False      'Kstchen VOR Outlook-bernahme
        Me.Kontrollkstchen225.Enabled = False      'Strenge Prfung
    Else
        '...nur Kategorien aus der Liste
        Me.Kategorievorgaben.Enabled = True
        Me.Befehl_Textdatei_lesen.Enabled = True
        Me.Pfadeingabe.Enabled = True
        Me.Feld_KategorieWo.Enabled = True
        Me.Feld_WoVon.Enabled = True
        Me.Feld_WoBis.Enabled = True
        Me.Feld_Trennzeichen.Enabled = True
        Me.Feld_Anfuehrung.Enabled = True
        Me.Befehl13.Enabled = True                 'Datei suchen
        Me.Kontrollkstchen187.Enabled = True      'Kstchen VOR Outlook-bernahme
        Me.Kontrollkstchen225.Enabled = True      'Strenge Prfung
    End If
    'Aktivierung/Deaktivierung briger Felder
    If Me.Feld_UebernahmeArt.Value = 1 Then         ' nur ausfhren, wenn Kategorieliste aktiviert ist
        If Me.Feld_KategorieWo.Value = "P" Then     ' "P" absolute Position oder "D" Datensatz
            Me.Feld_WoBis.Enabled = True
            Me.Feld_Trennzeichen.Enabled = False
        Else
            Me.Feld_WoBis.Enabled = False
            Me.Feld_Trennzeichen.Enabled = True
        End If
    End If
    
End Sub

Private Sub Feld_WoBis_LostFocus()
    If (Me.Feld_WoBis.Value < 0) Or (Me.Feld_WoBis.Value > 250) Then
        MsgBox "Die Zahl fr das Ende muss zwischen 0 und 250 liegen.", vbOKOnly + vbCritical, "Fehler"
        Me.Feld_WoBis.SetFocus
        Exit Sub
    End If
    If Me.Feld_WoBis.Value < Me.Feld_WoVon.Value Then
        MsgBox "Die Zahl fr das Ende muss grer oder gleich der Zahl fr den Beginn sein.", vbOKOnly + vbCritical, "Fehler"
        Me.Feld_WoBis.SetFocus
        Exit Sub
    End If
End Sub

Private Sub Feld_WoVon_LostFocus()
    If (Me.Feld_WoVon.Value < 0) Or (Me.Feld_WoVon.Value > 250) Then
        MsgBox "Die Zahl fr den Beginn muss zwischen 0 und 250 liegen.", vbOKOnly + vbCritical, "Fehler"
        Me.Feld_WoVon.SetFocus
        Exit Sub
    End If
End Sub

Private Sub Form_Activate()
    'Aktivierung/Deaktivierung briger Felder
    If Me.Feld_UebernahmeArt.Value = 1 Then         ' nur ausfhren, wenn Kategorieliste aktiviert ist
        If Me.Feld_KategorieWo.Value = "P" Then     ' "P" absolute Position oder "D" Datensatz
            Me.Feld_WoBis.Enabled = True
            Me.Feld_Trennzeichen.Enabled = False
        Else
            Me.Feld_WoBis.Enabled = False
            Me.Feld_Trennzeichen.Enabled = True
        End If
    End If
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    
    
    'Felder aktivieren/deaktivieren
    If Me.Feld_UebernahmeArt.Value = 0 Then
        '...alle Kategorien
        Me.Kategorievorgaben.Enabled = False
        Me.Befehl_Textdatei_lesen.Enabled = False
        Me.Pfadeingabe.Enabled = False
        Me.Feld_KategorieWo.Enabled = False
        Me.Feld_WoVon.Enabled = False
        Me.Feld_WoBis.Enabled = False
        Me.Feld_Trennzeichen.Enabled = False
        Me.Feld_Anfuehrung.Enabled = False
        Me.Befehl13.Enabled = False                 'Datei suchen
        Me.Kontrollkstchen187.Enabled = False      'Kstchen VOR Outlook-bernahme
        Me.Kontrollkstchen225.Enabled = False      'Strenge Prfung
    Else
        '...nur Kategorien aus der Liste
        Me.Kategorievorgaben.Enabled = True
        Me.Befehl_Textdatei_lesen.Enabled = True
        Me.Pfadeingabe.Enabled = True
        Me.Feld_KategorieWo.Enabled = True
        Me.Feld_WoVon.Enabled = True
        Me.Feld_WoBis.Enabled = True
        Me.Feld_Trennzeichen.Enabled = True
        Me.Feld_Anfuehrung.Enabled = True
        Me.Befehl13.Enabled = True                 'Datei suchen
        Me.Kontrollkstchen187.Enabled = True      'Kstchen VOR Outlook-bernahme
        Me.Kontrollkstchen225.Enabled = True      'Strenge Prfung
    End If
    
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Pfadeingabe_LostFocus()
    Dim DateiSuche As String
    
    
    'Prfung, ob angegebene Datei vorhanden ist
    DateiSuche = ""
    On Error Resume Next                    'Meldung "Pfad nicht gefunden" unterdrcken!
    DateiSuche = Dir(Trim(Me.Pfadeingabe.Value))
    'On Error GoTo Err_....     'Fehlerbehandlung wieder einschalten
    If (DateiSuche = "") Then               'Datei auch vorhanden?
        MsgBox "Die angegebene Textdatei wurde nicht gefunden.", vbOKOnly + vbCritical, "Fehler"
        Me.Pfadeingabe.SetFocus
        Exit Sub
    End If
End Sub

Private Sub ZuEinstellungen1_Click()
On Error GoTo Err_ZuEinstellungen1_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_6", acSaveYes
    

Exit_ZuEinstellungen1_Click:
    Exit Sub

Err_ZuEinstellungen1_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen1_Click
    
End Sub

Private Sub ZuEinstellungen2_Click()
On Error GoTo Err_ZuEinstellungen2_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_2"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_6", acSaveYes
    

Exit_ZuEinstellungen2_Click:
    Exit Sub

Err_ZuEinstellungen2_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen2_Click
    
End Sub

Private Sub ZuEinstellungen3_Click()
On Error GoTo Err_ZuEinstellungen3_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_3"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_6", acSaveYes
    

Exit_ZuEinstellungen3_Click:
    Exit Sub

Err_ZuEinstellungen3_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen3_Click
    
End Sub

Private Sub ZuEinstullungen4_Click()
On Error GoTo Err_ZuEinstellungen4_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_4"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_6", acSaveYes
    

Exit_ZuEinstellungen4_Click:
    Exit Sub

Err_ZuEinstellungen4_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen4_Click
    
End Sub

Private Sub ZuEinstullungen6_Click()
On Error GoTo Err_ZuEinstellungen6_Click

    Dim stDocName As String
    Dim stLinkCriteria As String

    stDocName = "Einstellungen_6"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Einstellungen_6", acSaveYes
    

Exit_ZuEinstellungen6_Click:
    Exit Sub

Err_ZuEinstellungen6_Click:
    MsgBox err.Description
    Resume Exit_ZuEinstellungen6_Click

End Sub
